#include <iostream>					// used for console io
#include <fstream>					// used for file io
#include <cstdlib>					// allows use of srand()
#include <ctime>					// used to initialize random number generator
#include <string>					// used for str.find() and string::npos

using namespace std;

const int wordsInLibrary = 20;		// Number of words stored in the library file
const string libPath = "lib.txt";	// Path to the library file

// Function prototype allowing easy retrieval of all words from a text file
// Results are stored in words[]
void getWordsFromLibrary(string words[]);

int main()
{
	int wordCount;					// how many words to be added to the phrase
	bool unique = true;				// if each word in phrase is unique
	string result;					// the result pass phrase
	string words[wordsInLibrary];	// stores all words from the library file

	getWordsFromLibrary(words);		// retrieves all words from library

	if (words[0] == "")				// if first word is missing,
	{
		system("PAUSE");			// suspend application then close with error code
		return 1;
	}

	srand((unsigned)time(0));		// initalizes random number generator

	cout << "Please enter the number of words in the phrase: ";
	cin >> wordCount;				// retrieves # of words in phrase

	while (wordCount <= 0)
	{
		cout << "Please enter a positive number: ";
		cin >> wordCount;
	}

	if (wordCount > wordsInLibrary) 
		unique = false;				// if too many words requested, cannot be unique

	while (wordCount-- > 0)
	{
		int random;					// stores index of word to add to phrase
		if (unique)					
			while (result.find(words[random = (rand() % wordsInLibrary)]) 
				!= string::npos) {} // until we find a word not in the phrase, 
									// keep randomizing the index
		else
			random = rand() % wordsInLibrary; 
									// get a value from 0 to wordsInLibrary

		result += words[random];	// add word to phrase
	}

	cout << "The result phrase: " << result << endl << endl; // output final result

	system("PAUSE");				// suspend application until any key press
	return 0;
}

// Function prototype allowing easy retrieval of all words from a text file
// Results are stored in words[]
void getWordsFromLibrary(string words[]) 
{
	string line = "";
	ifstream lib(libPath);	// open file

	int index = 0;			// index to store line at
	if (lib.is_open())		// if open, read each line and add to words 
		while (lib >> line)
			words[index++] = line;
	else
		cout << "Error reading library, closing application." << endl << endl;
}